extends Node2D

func _ready() -> void:
	# ConfigFileで保存する
	var config = ConfigFile.new()
	config.set_value("player", "name", "勇者")
	config.set_value("player", "hp", 100)
	config.set_value("player", "position", Vector2(12, 8))

	config.set_value("enemy", "name", "スライム")
	config.set_value("enemy", "hp", 10)
	config.set_value("enemy", "position", Vector2(5, 10))

	config.save("user://game.cfg")
	
	# 暗号化する場合は以下のセーブ処理を呼び出す
	#config.save_encrypted_pass("user://game.cfg", "pass")

func _process(delta: float) -> void:
	if Input.is_action_just_pressed("ui_up"):
		_load_and_print()
	if Input.is_action_just_pressed("ui_down"):
		_load_and_print2()

func _load_and_print() -> void:
	var config = ConfigFile.new()
	
	# Configファイルを読み込む
	var ret = config.load("user://game.cfg")
	#var ret = config.load_encrypted_pass("user://game.cfg", "pass")
	if ret != OK:
		return # 読み込み失敗
	
	# セクションとキーを指定して値を取得する
	print("player name     :", config.get_value("player", "name"))
	print("player hp       :", config.get_value("player", "hp"))
	print("player position :", config.get_value("player", "position"))

	print("enemy name      :", config.get_value("enemy", "name"))
	print("enemy hp        :", config.get_value("enemy", "hp"))
	print("enemy position  :", config.get_value("enemy", "position"))

func _load_and_print2() -> void:
	var config = ConfigFile.new()
	
	# Configファイルを読み込む
	var ret = config.load("user://game.cfg")
	if ret != OK:
		return # 読み込み失敗
	
	# すべてのセクションとキーを出力する
	for section in config.get_sections():
		for key in config.get_section_keys(section):
			print("%s %8s :"%[section, key], config.get_value(section, key))
