# Dialog Class



### Methods:
#### start()
`start(timeline: String, reset_saves: bool=true, dialog_scene_path: String="res://addons/dialogic/Nodes/DialogNode.tscn", debug_mode: bool=false, use_canvas_instead=true)`
Starts the dialog for the given timeline and returns a Dialog node.
You must then add it manually to the scene to display the dialog.

Example:
var new_dialog = Dialogic.start('Your Timeline Name Here')
add_child(new_dialog)

This is exactly the same as using the editor:
you can drag and drop the scene located at /addons/dialogic/Dialog.tscn 
and set the current timeline via the inspector.

@param timeline			The timeline to load. You can provide the timeline name or the filename.
@param reset_saves		True to reset dialogic saved data such as definitions.
@param dialog_scene_path	If you made a custom Dialog scene or moved it from its default path, you can specify its new path here.
@param debug_mode		Debug is disabled by default but can be enabled if needed.
@param use_canvas_instead	Create the Dialog inside a canvas layer to make it show up regardless of the camera 2D/3D situation.
@returns			A Dialog node to be added into the scene tree.


#### start_from_save()
`start_from_save(timeline: String, initial_timeline: String, dialog_scene_path: String="res://addons/dialogic/Nodes/DialogNode.tscn", debug_mode: bool=false)`
Same as the start method above, but using the last timeline saved.

@param timeline              	The current timeline to load
@param initial_timeline		The timeline to load in case no save is found.
@param dialog_scene_path	If you made a custom Dialog scene or moved it from its default path, you can specify its new path here.
@param debug_mode		Debug is disabled by default but can be enabled if needed.
@returns			A Dialog node to be added into the scene tree.

## Previously on the Dialogic Singleton (RIP - rest in pain)

#### set_current_timeline()
#### get_current_timeline()

#### get_definitions()
#### set_definitions()
#### set_variable()
#### get_variable()
#### set_glossary_from_id()
#### set_variable_from_id()

#### save_defintions()

