# Emit Signal
![image](./Images/Event_Emit_Signal.PNG)

The `Emit Signal` event will emit the signal `dialogic_signal` of the **current dialog node** and pass the given string as an **argument**.
The event does NOT create a new signal!

If you instance your dialog via script, use a code similar to this:
`func start_dialog():
	var dialog = Dialogic.start("my_timeline")
	dialog.connect("dialogic_signal", self, "dialog_listener")
	add_node(dialog)

func dialog_listener(string):
	match string:
		"quest_point_two":
			# do something
			pass
`

If you instanced the scene using the editor you can connect the signal like you would always do in Godot from the `NODE TAB > Signals`.

*If you don't know about signals you should definitely learn about them. For example [here](https://docs.godotengine.org/en/stable/getting_started/step_by_step/signals.html).*