extends Area2D

export var can_drag = true
export var piece_id = 0

var _entered = false
var _dragging = false
var _dragging_position = Vector2()

onready var polygon = $Polygon2D
onready var collision = $CollisionPolygon2D

func _ready() -> void:
	if can_drag == false:
		# ドラッグ操作できない場合はグレーアウトする
		polygon.modulate = Color.black

func _process(delta: float) -> void:
	if can_drag:
		_update_drag()

func _update_drag() -> void:
	# ドラッグ操作
	var mouse = get_viewport().get_mouse_position()	
	
	polygon.modulate = Color.white
	
	if _dragging:
		# ドラッグによる移動処理
		polygon.modulate = Color.red
		var d = mouse - _dragging_position
		position += d
		_dragging_position = mouse
		if Input.is_action_pressed("ui_click") == false:
			_dragging = false
	else:
		# ドラッグしていないのでドラッグ判定
		if _entered:
			if Input.is_action_just_pressed("ui_click"):
				# ドラック開始
				_dragging = true
				_dragging_position = mouse			

func _on_Piece_mouse_entered() -> void:
	# マウスが領域内に入った
	_entered = true

func _on_Piece_mouse_exited() -> void:
	# マウスが猟奇外に出た
	_entered = false

func _on_Piece_area_entered(area: Area2D) -> void:
	# コリジョンが重なった
	print("area_entered: %s"%area.name)
