extends Area2D

var _entered = false # マウスがコリジョン内にあるかどうか
var _dragging = false # ドラッグ中かどうか
var _dragging_position = Vector2() # ドラッグ開始座標

onready var polygon = $Polygon2D

func _process(delta: float) -> void:
	# ドラッグ操作
	var mouse = get_viewport().get_mouse_position()	
	
	polygon.modulate = Color.white
	
	if _dragging:
		# ドラッグによる移動処理
		polygon.modulate = Color.red
		var d = mouse - _dragging_position
		position += d
		_dragging_position = mouse
		if Input.is_action_pressed("ui_click") == false:
			_dragging = false
	else:
		# ドラッグしていないのでドラッグ判定
		if _entered:
			if Input.is_action_just_pressed("ui_click"):
				# ドラック開始
				_dragging = true
				_dragging_position = mouse			

func _on_Area2D_mouse_entered() -> void:
	_entered = true # マウスがコリジョン内に存在する

func _on_Area2D_mouse_exited() -> void:
	_entered = false # マウスがコリジョンの外に出た
