extends Node2D


@onready var player = $AudioStreamPlayer2D
@onready var label = $Label

func _ready() -> void:
	pass # Replace with function body.

func _process(_delta: float) -> void:
	# オーディオ情報の表示
	var text = "Position: %3.2f\n"%player.get_playback_position()
	text += "Volume dB: %3.2f\n"%player.volume_db
	text += "Pitch: %3.2f\n"%player.pitch_scale
	label.text = text
	

# 再生
func _on_ButtonPlay_pressed() -> void:
	player.play()

# 停止
func _on_ButtonStop_pressed() -> void:
	player.stop()

# ピッチの変更
func _on_SpinBoxPitch_value_changed(value: float) -> void:
	player.pitch_scale = value

# 音量の変更
func _on_HSliderVolume_value_changed(value: float) -> void:
	# 0〜100を -10.0〜10.0 に変換する
	var vol = ((value - 50) / 100.0) * 20.0
	player.volume_db = vol

# ピッチの変更
func _on_HSliderPitch_value_changed(value: float) -> void:
	# 0〜100 を 0.0〜4.0 に変換する
	var pitch = (value / 100.0) * 4.0
	player.pitch_scale = pitch

# リバーブを有効にする
func _on_CheckBoxReverb_toggled(button_pressed: bool) -> void:
	if button_pressed:
		player.bus = "Reverb"

# マスターに戻す
func _on_CheckBoxMaster_toggled(button_pressed: bool) -> void:
	if button_pressed:
		player.bus = "Master"

# ディレイを有効にする
func _on_CheckBoxDelay_toggled(button_pressed: bool) -> void:
	if button_pressed:
		player.bus = "Delay"
